% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxExpMeans}
\alias{umxExpMeans}
\title{umxExpMean}
\usage{
umxExpMeans(model, manifests = TRUE, latents = NULL, digits = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get the means from}

\item{manifests}{Whether to select the manifest variables (defaults to TRUE)}

\item{latents}{Whether to select the latent variables (defaults to TRUE)}

\item{digits}{precision of reporting. Default (NULL) will not round at all.}
}
\value{
- expected means
}
\description{
Extract the expected means matrix from an \code{\link{mxModel}}
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = "one", to = manifests),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(demoOneFactor, type = "raw")
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umxExpMeans(model = m1)
umxExpMeans(m1, digits = 3)
}
\references{
- \url{http://openmx.psyc.virginia.edu/thread/2598}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{confint.MxModel}},
  \code{\link{extractAIC.MxModel}},
  \code{\link{logLik.MxModel}}, \code{\link{plot.MxModel}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxExpCov}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACE}},
  \code{\link{umxStandardizeModel}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACE}}, \code{\link{umx_drop_ok}}
}

