% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_scale_wide_twin_data}
\alias{umx_scale_wide_twin_data}
\title{umx_scale_wide_twin_data}
\usage{
umx_scale_wide_twin_data(varsToScale, suffix, data)
}
\arguments{
\item{varsToScale}{The base names of the variables ("weight" etc)}

\item{suffix}{The suffix that distinguishes each case, e.g. "_T")}

\item{data}{a wide dataframe}
}
\value{
- new dataframe with variables scaled in place
}
\description{
Scale wide data across all cases: currently twins
}
\examples{
data(twinData) 
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffix = "" )
plot(wt1 ~ wt2, data = df)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

