% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxGxE_biv.R
\name{umxSummaryGxE_biv}
\alias{umxSummaryGxE_biv}
\alias{umxSummary.MxModel.GxE_biv}
\title{Summarize a bivariate GxE twin model}
\usage{
umxSummaryGxE_biv(model = NULL, digits = 2, xlab = NA,
  location = "topleft", separateGraphs = FALSE,
  file = getOption("umx_auto_plot"), returnStd = NULL, comparison = NULL,
  std = NULL, reduce = FALSE, CIs = NULL, report = c("markdown",
  "html"), ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxGxE_biv}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{Std and raw plots in separate graphs? (default = FALSE)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{comparison}{mxCompare model with comparison (defaut = NULL).}

\item{std}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether to run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{markdown or html (html opens in browswer)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
umxSummaryGxE_biv summarize a Moderation model, as returned by \code{\link{umxGxE_biv}}.
}
\examples{
data(twinData) 
selDVs  = "wt"
selDefs = "ht"
df = umx_scale_wide_twin_data(twinData, varsToScale = c("ht", "wt"), suffix = "")
mzData  = subset(df, zygosity \%in\%  c("MZFF", "MZMM"))
dzData  = subset(df, zygosity \%in\%  c("DZFF", "DZMM", "DZOS"))

\dontrun{
m1 = umxGxE_biv(selDVs = selDVs, selDefs = selDefs, 
	dzData = dzData, mzData = mzData, sep = "", dropMissingDef = TRUE)
# Plot Moderation
umxSummary(m1)
umxSummary(m1, location = "topright")
umxSummary(m1, separateGraphs = FALSE)
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxGxE_biv}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_biv}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxSexLim}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
