% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_string_to_algebra}
\alias{umx_string_to_algebra}
\title{Convert a string to an OpenMx algebra}
\usage{
umx_string_to_algebra(algString, name = NA, dimnames = NA)
}
\arguments{
\item{algString}{a string to turn into an algebra}

\item{name}{of the returned algebra}

\item{dimnames}{of the returned algebra}
}
\value{
- \code{\link{mxAlgebra}}
}
\description{
This is useful use to quickly and easily insert values from R variables into the string (using paste() and rep() etc.), then parse the string as an mxAlgebra argument.
A use case is including a matrix exponent (that is A %*% A %*% A %*% A...) with a variable exponent.
}
\examples{
\dontrun{
alg = umx_string_to_algebra(paste(rep("A", nReps), collapse = " \%*\% "), name = "test_case")
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxRAM2Ordinal}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}}, \code{\link{umx_add_variances}},
  \code{\link{umx_fix_first_loadings}},
  \code{\link{umx_fix_latents}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx}}
}
