% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_move_file}
\alias{umx_move_file}
\title{Move files}
\usage{
umx_move_file(baseFolder = NA, regex = NULL, fileNameList = NA,
  destFolder = NA, test = TRUE, overwrite = FALSE)
}
\arguments{
\item{baseFolder}{The folder to search in. If set to "Finder" (and you are on OS X) it will use the current front-most Finder window. If it is blank, a choose folder dialog will be thrown.}

\item{regex}{= regex string select files to move (WARNING: NOT IMPLEMENTED YET)}

\item{fileNameList}{List of files to move}

\item{destFolder}{Folder to move files into}

\item{test}{Boolean determining whether to change the names, or just report on what would have happened}

\item{overwrite}{Boolean determining whether to overwrite files or not (default = FALSE (safe))}
}
\value{
-
}
\description{
On OS X, umx_move_file can access the current front-most Finder window.
The file moves are fast and, because you can use regular expressions, powerful.
}
\examples{
\dontrun{
base = "/Users/tim/Music/iTunes/iTunes Music/"
dest = "/Users/tim/Music/iTunes/iTunes Music/Music/"
umx_move_file(baseFolder = base, fileNameList = toMove, destFolder = dest, test= FALSE)
}
}
\seealso{
Other File Functions: \code{\link{dl_from_dropbox}},
  \code{\link{umx_make_sql_from_excel}},
  \code{\link{umx_open}}, \code{\link{umx_rename_file}},
  \code{\link{umx_write_to_clipboard}}, \code{\link{umx}}
}
\concept{File Functions}
