% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_merge_randomized_columns}
\alias{umx_merge_randomized_columns}
\title{umx_merge_randomized_columns}
\usage{
umx_merge_randomized_columns(
  colNames,
  df,
  levels = colNames,
  newVarName = "score",
  newCondName = "condition",
  as.factor = FALSE
)
}
\arguments{
\item{colNames}{Names of the columns containing the condition data.}

\item{df}{The data frame}

\item{levels}{optional names for the levels of condition (default = colNames).}

\item{newVarName}{Name for the new column holding the newVarName (default "score").}

\item{newCondName}{Name for the new column holding the condition (default "condition").}

\item{as.factor}{Turn condition into a factor? (FALSE)}
}
\value{
\itemize{
\item df with new cols
}
}
\description{
\code{umx_merge_randomized_columns} is designed to merge data where subjects have been randomized
to conditions, so they have a value in one column, and NA in the other condition columns.

It returns a new column of merged scores, and a new column of associated conditions.
}
\examples{
\dontrun{
fp = "~/Desktop/Political Ideology_September 13, 2022_10.47.xlsx"
df = readxl::read_excel(fp)
df = df[c(-1,-2), ] # delete temp data and question text
df = data.frame(df)
namez(df, "ris", coll = "vec") # c('RiskAversionNoLotter', 'RiskAversionLottery')
colNames= c('RiskAversionNoLotter', 'RiskAversionLottery')
df = umx_as_numeric(df, colNames, force=TRUE)
tmp = umx_merge_randomized_columns(colNames, df); table(tmp$condition)
tmp = umx_merge_randomized_columns(colNames, df, 
	levels = c("treatment", "control")); table(tmp$condition)
}
}
\seealso{
\itemize{
\item \code{\link[=umx_long2wide]{umx_long2wide()}}
}

Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_check_ID}()},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_read_prolific_demog}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
