% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_unga.R
\name{table_unga}
\alias{table_unga}
\title{A function for cross tabulation.}
\usage{
table_unga(qalt, sumopt, expvar, x)
}
\arguments{
\item{qalt}{Number of response alternatives in a survey question}

\item{sumopt}{Options for summation of proportions questions with 5 or 6
response alternatives, argument can be 1 or 2}

\item{expvar}{Explanatory variable in your data frame, use numeric values}

\item{x}{is a data frame}
}
\value{
the output from \code{\link{print}}
}
\description{
Produces multiple prop.tables of
a data frame. Extract questions with a specified number of response
alternatives.
}
\examples{
set.seed(123456)
gender<-round(runif(50,1,2))
variable_1<-round(runif(50,1,5))
variable_2<-round(runif(50,1,5))
variable_3<-round(runif(50,1,5))
df<-data.frame(gender,variable_1,variable_2,variable_3)
table_unga(5,1,gender,df)
}
\references{
Norman M. Bradburn et al. 2004. Asking questions. 2nd revised
edition. John Wiley & Sons
}
