% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McGill.R
\docType{data}
\name{mcgill_red}
\alias{mcgill_red}
\title{Primary colour of McGill University, Canada}
\format{
An object of class \code{character} of length 1.
}
\source{
Colour definitions are based on \href{https://www.mcgill.ca}{McGill}'s 
\href{https://www.mcgill.ca/visual-identity/visual-identity-guide}{visual identity guide}.
}
\usage{
mcgill_red
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{mcgill_red} provides the primary color "McGill Red" (or \code{mcgill_red})
of \href{https://www.mcgill.ca}{McGill University}, Canada.
}
\details{
The primary colour is called 
\code{"McGill red"} and defined as CMYK 0/100/90/0, RGB 237/27/47, HEX #ed1b2f.

\code{mcgill_red} uses the HEX colour definition.
 
Note that the CMYK colour differs from the RGB and HEX definitions.
}
\examples{
mcgill_red
unikn::seecol(mcgill_red, main = "McGill red") # view colour palette

}
\seealso{
\code{\link{mcgill_pastels}} for the pastel colours of McGill;
\code{\link{mcgill_brights}} for the bright colours of McGill;
\code{\link{mcgill_muted}} for the muted colours of McGill;
\code{\link{mcgill_darks}} for the dark colours of McGill;
\code{\link{mcgill_grey}} for the grey of McGill;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
