% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{runif_sphere}
\alias{runif_sphere}
\alias{runif_on_sphere}
\alias{runif_in_sphere}
\title{Uniform sampling on/in sphere}
\usage{
runif_on_sphere(n, d, r = 1)

runif_in_sphere(n, d, r = 1)
}
\arguments{
\item{n}{number of simulations}

\item{d}{dimension of the space}

\item{r}{radius of the sphere}
}
\value{
The simulations in a \code{n} times \code{d} matrix.
}
\description{
Uniform sampling on a sphere or in a sphere, in arbitrary
dimension.
}
\examples{
sims <- runif_on_sphere(20, d = 2)
plot(sims, xlim = c(-1, 1), ylim = c(-1, 1), asp = 1, pch = 19)
sims <- runif_in_sphere(100, d = 2)
plot(sims, xlim = c(-1, 1), ylim = c(-1, 1), asp = 1, pch = 19)
}
