% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{unitizer_demo}
\alias{unitizer_demo}
\alias{fastlm_dir}
\alias{show_file}
\alias{unitizer_check_demo_state}
\alias{unitizer_cleanup_demo}
\alias{`[Press}
\alias{ENTER}
\alias{to}
\alias{Continue]`}
\alias{[Press ENTER to Continue]}
\alias{show_file}
\alias{copy_fastlm_to_tmpdir}
\alias{update_fastlm}
\alias{unitizer_check_demo_state}
\alias{unitizer_cleanup_demo}
\title{Demo Details and Helper Functions}
\usage{
"[Press ENTER to Continue]"()

show_file(f, width = getOption("width", 80L))

copy_fastlm_to_tmpdir()

update_fastlm(dir, version)

unitizer_check_demo_state()

unitizer_cleanup_demo()
}
\arguments{
\item{f}{path to a file}

\item{width}{display width in characters}

\item{dir}{path to the temporary package}

\item{version}{one of "0.1.0", "0.1.1", "0.1.2"}
}
\value{
character(1L)
}
\description{
\code{unitizer} provides an interactive demo you can run with
\code{demo("unitizer")}.
}
\section{Demo Details}{


The demo centers around simulated development of the \code{utzflm}
package.  \code{unitizer} includes in its sources three copies of the source
code for the \code{utzflm} package, each at a different stage of
development.  This allows us to create reference \code{unitizer} tests under
one version, move to a new version and check for regressions, and finally
fix the regressions with the last version.  The version switching is
intended to represent the package development process.

The demo manages the \code{utzflm} code changes, but between each
update allows the user to interact with \code{unitizer}.  The demo operates
under the assumption that the user will accept the first set of tests and
reject the failing tests after the first update.  If the user does anything
different then the demo commentary may not apply anymore.
}

\section{\code{utzflm}}{


\code{utzflm} is a "dummy" package that implements a faster
computation of slope, intercept, and R^2 for single variable linear
regressions than is available via \code{summary(lm()...)}.
}

\section{Helper Functions}{


\code{copy_fastlm_to_tmpdir} copies the initial version of the
\code{utzflm} sources to a temporary directory, \code{show_file}
displays the contents of a source code file, \code{update_fastlm} changes the
source code of \code{utzflm}, and \code{unitizer_check_demo_state}
and \code{unitizer_cleanup_demo} perform janitorial functions.  None of
these functions are intended for use outside of the unitizer demo.
}

