% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npdims.R
\name{npdims}
\alias{npdims}
\alias{npdims.default}
\title{Number of Parameter Dimensions}
\usage{
npdims(x, ...)

\method{npdims}{default}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A named integer vector of the number of dimensions of each parameter.
}
\description{
Gets the number of the dimensions of each parameter of an object.

The default methods returns the length of each element of \code{\link[=pdims]{pdims()}}
as an integer vector.
}
\examples{
npdims.foobar <- function(x, ...) {
  vapply(pdims(x, ...), length, 1L)
}
}
\seealso{
Other dimensions: 
\code{\link{dims}()},
\code{\link{ndims}()},
\code{\link{pdims}()}
}
\concept{dimensions}
