% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhat.R
\name{rhat}
\alias{rhat}
\title{R-hat}
\usage{
rhat(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A number >= 1 indicating the rhat value.
}
\description{
Calculates an R-hat (potential scale reduction factor) value.
}
\details{
By default the uncorrected, unfolded, univariate,
split R-hat value.
}
\references{
Gelman, A., and Rubin, D.B. 1992.
Inference from Iterative Simulation Using Multiple Sequences.
Statistical Science 7(4): 457–472.
}
\seealso{
Other convergence: 
\code{\link{converged_pars}()},
\code{\link{converged_terms}()},
\code{\link{converged}()},
\code{\link{esr_pars}()},
\code{\link{esr_terms}()},
\code{\link{esr}()},
\code{\link{rhat_pars}()},
\code{\link{rhat_terms}()}
}
\concept{convergence}
