% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_all_post_prob}
\alias{compute_all_post_prob}
\title{Computes every posterior probability for each dosage level for
each individual at each SNP.}
\usage{
compute_all_post_prob(ploidy, mu, sigma2, alpha, rho)
}
\arguments{
\item{ploidy}{The ploidy of the species.}

\item{mu}{A matrix of variational posterior means. The rows
index the individuals and the columns index the SNPs.}

\item{sigma2}{A matrix of variational posterior variances.
The rows index the individuals and the columns index the SNPs.}

\item{alpha}{A vector of allele frequencies for all SNPs.}

\item{rho}{A vector of inbreeding coefficients for all individuals.}
}
\value{
An array. The rows index the individuals, the columns index the 
    SNPS, and the third dimension indexes the genotypes. Element (i, j, k)
    is the return of \code{\link{post_prob}}.
}
\description{
Computes every posterior probability for each dosage level for
each individual at each SNP.
}
\author{
David Gerard
}
