% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burndown.R
\name{storypoints_and_status}
\alias{storypoints_and_status}
\title{Calculate storypoints ans status of the Cards of a specific Board}
\usage{
storypoints_and_status(organisation, board_id, token)
}
\arguments{
\item{organisation}{A character. The name of the organisation as specified in the URL:
https://<organisation>.upwave.io}

\item{board_id}{An integer. The number of the board you want to inspect as specified in
the URL: https://<organisation>.upwave.io/board/<board_id>/view/}

\item{token}{A character. The API token to access boards on upwave.io. The token can be
obtained by visiting your account settings. Click your profile image, select "Settings"
and find your API-Key in the "Account" tab.}
}
\value{
A list containing a data.frame with all storypoints and the status per card and
the numeric sum_storypoints.
}
\description{
Calculates storypoints (of active Cards, which are Cards that haven't been completed
yet) and status in the backlog of an upwave board.
Storypoints have to be specified in the description (directly beneath the title) of
each card with a string of the form: "Aufwand: X SP" or "Aufwand: X AT". This is not
part of the upwave API but an additional functionality.
}
\examples{
upwaver::storypoints_and_status("ims-fhs", 14351, "a44fa67c5df2acc9836058ffca870d7b78b017cb")
}
