% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.r
\name{positionToIndex}
\alias{positionToIndex}
\title{positionToIndex}
\usage{
positionToIndex(row, col, nrow = max(row))
}
\arguments{
\item{row}{Vector specifying row positions}

\item{col}{Vector specifying column positions}

\item{nrow}{The number of rows in the matrix}
}
\value{
A vector of indices
}
\description{
Given row and column positions calculate the index.
}
\details{
With row and column positions this computes the index, starting at (1,1) working down rows then across columns.
}
\examples{
positionToIndex(1, 2, 2)
positionToIndex(row=c(1, 1, 2, 1, 3), col=c(1, 2, 2, 3, 3), nrow=3)
positionToIndex(rep(1:4, 4), rep(1:4, each=4), nrow=4)
positionToIndex(rep(c(1, 3, 5), 3), rep(1:3, each=3), nrow=5)

}
\author{
Jared P. Lander
}

