\name{determinantStructure Preprocessing}
\alias{detStructAddVarLabels}
\alias{detStructAddVarNames}
\alias{detStructComputeProducts}
\alias{detStructComputeScales}
\title{
Functions to preprocess determinant structures
}
\description{
These functions are used in conjunction with the \code{\link{determinantStructure}} family of funtions to conveniently work with determinant structures.
}
\usage{
detStructAddVarLabels(determinantStructure,
                      varLabelDf,
                      varNameCol = "varNames.cln",
                      leftAnchorCol = "leftAnchors",
                      rightAnchorCol = "rightAnchors",
                      subQuestionCol = "subQuestions",
                      questionTextCol = "questionText")

detStructAddVarNames(determinantStructure, names)

detStructComputeProducts(determinantStructure, dat, append = TRUE)

detStructComputeScales(determinantStructure, dat, append = TRUE, separator = "_")

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{determinantStructure}{
  The \code{\link{determinantStructure}} object.
}
  \item{varLabelDf}{
  The variable label dataframe as generated by \code{\link{processLSvarLabels}}.
  It is also possible to specify 'homemade' dataframe, in which case the
  column names have to specified (see the next arguments).
}
  \item{varNameCol}{
  The name of the column of the \code{varLabelDf} that contains the
  variable name. Only needs to be changed from the default value if
  \code{varLabelDf} is not a dataframe as produced by \code{\link{processLSvarLabels}}.
}
  \item{leftAnchorCol}{
  The name of the column of the \code{varLabelDf} that contains the
  left anchor. Only needs to be changed from the default value if
  \code{varLabelDf} is not a dataframe as produced by \code{\link{processLSvarLabels}}.
}
  \item{rightAnchorCol}{
  The name of the column of the \code{varLabelDf} that contains the
  right anchor. Only needs to be changed from the default value if
  \code{varLabelDf} is not a dataframe as produced by \code{\link{processLSvarLabels}}.
}
  \item{subQuestionCol}{
  The name of the column of the \code{varLabelDf} that contains the
  subquestion. Only needs to be changed from the default value if
  \code{varLabelDf} is not a dataframe as produced by \code{\link{processLSvarLabels}}.
}
  \item{questionTextCol}{
  The name of the column of the \code{varLabelDf} that contains the
  question text. Only needs to be changed from the default value if
  \code{varLabelDf} is not a dataframe as produced by \code{\link{processLSvarLabels}}.
}
  \item{names}{
  A character vector with the variable names. These are matched against the
  regular expressions as specified in the \code{\link{determinantStructure}}
  object, and any matches will be stored in the \code{\link{determinantStructure}}
  object.
}
  \item{dat}{
  The dataframe containing the data; the variables names specified in
  \code{names} (when calling \code{detStructAddVarNames}) must be present
  in this dataframe.
}
  \item{append}{
  Whether to only return the products or scales, or whether to append
  these to the dataframe and return the entire dataframe.
}
  \item{separator}{
  The separator to use when constructing the scale variables names.
}
}
\details{
This family of functions will be explained more in detail in a forthcoming
paper.
}
\value{
\code{detStructAddVarLabels} and \code{detStructAddVarNames} just change the
\code{\link{determinantStructure}} object; \code{detStructComputeProducts}
and \code{detStructComputeScales} return either the dataframe with the
new variables appended (if \code{append} = \code{TRUE}) or just a
dataframe with the new variables (if \code{append} = \code{FALSE}).
}
\references{
(Forthcoming)
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters <gjalt-jorn@userfriendlyscience.com>
}
\seealso{
\code{\link{determinantStructure}}, \code{\link{determinantVar}},
\code{\link{subdeterminants}}, \code{\link{subdeterminantProducts}},
\code{\link{detStructCIBER}}
}
\examples{
### Generate a silly determinant structure
detStruct <- determinantStructure('This makes no sense',
                                  list('mpg',
                                       behaviorRegEx = 'mpg'),
                                  determinantVar("Proximal determinant",
                                                 "t",
                                                 determinantVar("Determinant",
                                                                "p",
                                                                subdeterminants("Subdeterminants",
                                                                                "a"))));

### Add the variable names
detStructAddVarNames(detStruct, names(mtcars));

### Add the determinant scale variable to the dataframe
mtcarsPlus <- detStructComputeScales(detStruct, mtcars);

### Show its presence
names(mtcarsPlus);
mean(mtcarsPlus$mpg_Determinant);
}
\keyword{ utilities }
