% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_table.R
\name{build_table}
\alias{build_table}
\title{build_table}
\usage{
build_table(
  data = NULL,
  by = NULL,
  cols = NULL,
  skip = NULL,
  digits = 1,
  percent.sign = FALSE,
  less.than.one = FALSE,
  inverse = FALSE,
  indent = FALSE,
  parametric = FALSE,
  footer.stats = FALSE,
  p.digits = 4,
  remove.na = TRUE
)
}
\arguments{
\item{data}{Required. Tibble. Contains data to be summarized.}

\item{by}{Optional. Character. Name of factor or logical column to stratify
summaries by.}

\item{cols}{Optional. Character. Contains character names of columns to summarize. Defaults
to all columns.}

\item{skip}{Optional. Character. Names of columns to skip as part of predictor testing.}

\item{digits}{Optional. Integer. Number of digits to round numerics to. Defaults to 1.}

\item{percent.sign}{Optional. Logical. Indicates percent sign should be printed for
frequencies. Defaults to TRUE.}

\item{less.than.one}{Optional. Logical indicating whether means/medians that round to 0
should be printed as <1 (i.e. <1 [0-4]). Defaults to printing the 0.}

\item{inverse}{Optional. Logical. Indicates to summarize the FALSE/No data of logical columns
(i.e. 'Smoking Hx, yes' -> 'Smoking Hx, no'). Defaults to FALSE (Summarizes TRUE/Yes data).}

\item{indent}{Optional. Logical. Indent variable labels. Defaults to FALSE.}

\item{parametric}{Optional. Logical. Indicates parametric testing should be used for comparisons
(Fisher's exact and Student's Unpaired T-Test). Defaults to FALSE (non-parametric; Chi-squared and
Wilcox Rank-sum).}

\item{footer.stats}{Optional. Logical. Most stats summary into a footer row. Removes the stat
type from row labels. Defaults to FALSE.}

\item{p.digits}{Optional. Integer. Number of p-value digits to print. Note
that p-values are still rounded based on \'digits\' parameter. Defaults to 4.}

\item{remove.na}{Optional. Logical. Remove NA from denominator in frequency calculations.
Defaults to TRUE.}
}
\value{
Data is returned in the form of a tibble containing the row(s).
}
\description{
A function for summarizing columns of data. Can work in an automated fashion
or with manually specified options. It is essentially a wrapper for build_row().
}
\examples{
library(dplyr)

data_mtcars <- datasets::mtcars \%>\%
  as_tibble() \%>\%
  mutate_at(vars('vs', 'am'), as.logical) \%>\%
  mutate_at(vars('gear', 'carb', 'cyl'), as.factor)

build_table(
  data = data_mtcars,
  by = 'vs',
  cols = c(
    'gear',
    'mpg',
    'carb',
    'am',
    'hp'
  ),
  percent.sign = FALSE,
  less.than.one = TRUE,
  footer.stats = TRUE
)
}
