% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_ce}
\alias{plot_ce}
\title{Plotting controlled effect curves}
\usage{
plot_ce(
  ...,
  which = "CR",
  density_type = "none",
  dat = NA,
  zoom_x = "zoom in",
  zoom_y = "zoom out"
)
}
\arguments{
\item{...}{One or more objects of class \code{"vaccine_est"} returned by
\code{\link{est_ce}}.}

\item{which}{One of c("CR", "CVE"); controls whether to plot CR curves or CVE
curves.}

\item{density_type}{One of c("none", "kde", "kde edge").
Controls the type of estimator used for the background marker density
plot. For "none", no density plot is displayed. For "kde", a weighted
kernel density estimator is used. For "kde edge", a modified version of
"kde" is used that allows for a possible point mass at the left edge of
the marker distribution.}

\item{dat}{The data object originally passed into \code{\link{est_ce}}. It is
only necessary to pass this in if \code{density_type} is not set to
"none".}

\item{zoom_x}{Either one of c("zoom in", "zoom out") or a vector of
length 2. Controls the zooming on the X-axis. The default "zoom in" will
set the zoom limits to the plot estimates. Choosing "zoom out" will set
the zoom limits to show the entire distribution of the marker. Entering a
vector of length 2 will set the left and right zoom limits explicitly.}

\item{zoom_y}{Either "zoom out" or a vector of length 2. Controls the zooming
on the Y-axis. The default "zoom out" will show the entire vertical range
of the estimates. Entering a vector of length 2 will set the lower and
upper zoom limits explicitly.}
}
\value{
A plot of CR/CVE estimates
}
\description{
Plot CR and/or CVE curves
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_cox <- est_ce(dat=dat, type="Cox", t_0=578)
ests_np <- est_ce(dat=dat, type="NP", t_0=578)
plot_ce(ests_cox, ests_np)
}
}
