#' EQ-5D-3L tariffs using TTO for different countries
#' @format A 38 by 28 dataframe
#' @source \strong{Argentina}: Table 3 column 5 page 560 in Augustovski et al (2009) <doi:10.1111/j.1524-4733.2008.00468.x>
#' @source \strong{Australia}: Table 4 column 6 page 933 in Viney et al (2011) <doi:10.1016/j.jval.2011.04.009>
#' @source \strong{Brazil}: Table 2 column 8 page 21 in Santos et al (2016) <doi:10.1177/0272989X15613521>
#' @source \strong{Canada}: Table 4 column 2 page 8 in Bansback et al (2012) <https://doi.org/10.1371/journal.pone.0031115>
#' @source \strong{Chile}: Table 2 column 5 page 1137 in Zarate et al (2011) <doi:10.1016/j.jval.2011.09.002
#' @source \strong{China}: Table 4 column 4 page 603 in Liu et al (2014) <doi:10.1016/j.jval.2014.05.007>
#' @source \strong{Denmark}: Table 4 column 2 page 463 in Wittrup-Jensen et al (2009) <doi:10.1177/1403494809105287>
#' @source \strong{France}: Equation page 61 in Chevalier et al (2013) <doi:10.1007/s10198-011-0351-x>
#' @source \strong{Germany}: Table 4 column 2 page 129 in Greiner et al (2005) <doi:10.1007/s10198-004-0264-z>
#' @source \strong{Hungary}: Table 2 column 11 page 1238 in  Rencz et al (2020) <doi:10.1016/j.jval.2020.03.019>
#' @source \strong{Iran}: Table 3 column 8 page 174 in  Goudarzi et al (2019) <doi:10.1016/j.vhri.2019.01.007>
#' @source \strong{Italy}: Table 4 column 5 page 820 in Scalone et al (2013) <http://dx.doi.org/10.1016/j.jval.2013.04.008>
#' @source \strong{Japan}: Table 4 column 1 page 41 in Tsuchiya et al (2002) <https://doi.org/10.1002/hec.673>
#' @source \strong{South Korea}: Table 3 column 4 page 1191 in Lee et al <doi:10.1111/j.1524-4733.2009.00579.x>
#' @source \strong{Malaysia}: Table 4 column 5 page 588 in Aryani et al <doi:10.1016/j.jval.2011.11.024>
#' @source \strong{Netherlands}: Table 5 column 3 page 1128 in Lamers et al <doi:10.1002/hec.1124>
#' @source \strong{Poland}: Table 5 column 2 page 293 in Golicki et al <https://doi.org/10.1111/j.1524-4733.2009.00596.x>
#' @source \strong{Portugal}: Table 4 column 6 page 418 in Ferreira et al <doi:10.1007/s11136-013-0448-z>
#' @source \strong{Singapore}: Equation page  504 in Nan Luoß et al <doi:10.1007/s40273-014-0142-1>
#' @source \strong{Spain}: Table 3 column 4 page 13 in Badia et al (2001) <doi:10.1177/0272989X0102100102>
#' @source \strong{Sri Lanka}: Table 2 column 8 page 1791 in  Kularatna et al (2015) <doi:10.1007/s11136-014-0906-2>
#' @source \strong{Sweden}: Table 2 column 8 page 436 in Burström et al (2014) <doi:10.1007/s11136-013-0496-4>
#' @source \strong{Taiwan}: Table 2 column 4 page 702 in Lee et al (2013) <http://dx.doi.org/10.1016/j.jfma.2012.12.015> #'
#' @source \strong{Thailand}: Table 1 column 2 page 1144 (parameters like MO3 are calculated) Tongsiri et al (2011) <doi:10.1016/j.jval.2011.06.005>
#' @source \strong{Trinidad and Tobago}: Table 4 page 65 in Bailey et al (2016) <http://dx.doi.org/10.1016/j.vhri.2016.07.010>
#' @source \strong{UK}: Table 1 column 2 page 1103 in Dolan et al (1997) <http://dx.doi.org/10.1097/00005650-199711000-00002>
#' @source \strong{USA}: Table 5 column 2 page 214 in Shaw et al (2005) <doi:10.1097/00005650-200503000-00003>
#' @source \strong{Zimbabwe}: Table 5 column 3 page 7 in Jelsma et al (2003) <https://doi.org/10.1186/1478-7954-1-11>
"EQ5D3L_tariffs_TTO.df"

#' EQ-5D-3L tariffs using VAS for different countries
#' @format A 34 by 12 dataframe
#' @source \strong{Argentina}: Table 3 column 2 page 560 in Augustovski et al (2009) <doi:10.1111/j.1524-4733.2008.00468.x>
#' @source \strong{Belgium}: Equation 2 page 208 in Cleemput et al (2010) <doi:10.1007/s10198-009-0167-0>
#' @source \strong{Denmark}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Europe}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Finland}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Germany}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Malaysia}: Table 4 column 6 page S88 in Yusof et al (2019) <doi:10.1016/j.jval.2011.11.024>
#' @source \strong{New Zealand}: Equation 2 page 541 in Devlin et al <doi:10.1002/hec.741>
#' @source \strong{Slovenia}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Spain}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1> (this is not shown in euroqol website)
#' Could not get Sweden VAS values
#' @source \strong{UK}: Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
"EQ5D3L_tariffs_VAS.df"

#' EQ-5D-5L tariffs for different countries
#' @format A 34 by 22 data frame
#' @source \strong{Canada}: Table 2 column 5 page 103 in Xie et al (2016) <doi:10.1097/MLR.0000000000000447>
#' @source \strong{China}: Table 4 column 4 page 667 in Luo et al (2017) <doi:10.1016/j.jval.2016.11.016>
#' @source \strong{England}: Table 2 column 2 page 17 in Devlin et al (2018) <doi:10.1002/hec.3564>
#' @source \strong{Ethiopia}: Table 3 column 8 page 12 in Welie et al (2019) <doi:10.1016/j.vhri.2019.08.475>
#' @source \strong{France}: Table 3 column 2-6 page 12 in Andrade et al (2019) <doi::10.1007/s40273-019-00876-4>
#' @source \strong{Germany}: Table column 9 page 670 in Ludwig et al (2018) <doi:10.1007/s40273-018-0615-8>
#' @source \strong{Hong Kong}: Table 3 column 8 page 244 in Wong et al (2018) <doi:10.1007/s40271-017-0278-0>
#' @source \strong{Hungary}: Table 3 column 14 page 1241 in  Rencz et al (2020) <doi:10.1016/j.jval.2020.03.019>
#' @source \strong{Indonesia}: Table 3 column 8 page 1162 in Purba et al (2017) <doi:10.1007/s40273-017-0538-9>
#' @source \strong{Ireland}: Table 2 column 2 page 1348 in Hobbins et al (2016) <doi:10.1007/s40273-018-0690-x>
#' @source \strong{Japan}: Table 2 column 7 page 651 in Shiroiwa, et al (2016) <doi:10.1016/j.jval.2016.03.1834>
#' @source \strong{Korea}: Table 5 column 6 page 1851 in Kim et al (2016) <doi:10.1007/s11136-015-1205-2>
#' @source \strong{Malaysia}: Table 2 column 9 page 720 in Shafie  et al (2019) <doi:10.1007/s40273-018-0758-7>
#' @source \strong{Netherlands}: Table 4 column 8 page 350 in Versteegh et al (2016) <doi:10.1016/j.jval.2016.01.003>
#' @source \strong{Poland}: Table 2 column 7 in Golicki et al <doi:10.1007/s40273-019-00811-7>
#' @source \strong{Portugal}: Table 3 column 4 in Ferreira1 et al (2014) <doi:10.1007/s11136-019-02226-5>
#' @source \strong{Spain}: Table 1 column 9 page 5 in Ramos-Goñiet et al (2018) <https://doi.org/10.1016/j.jval.2017.10.023>
#' @source \strong{Taiwan}: Table 2 column 4 page 9 in Lin et al (2018)  <https://doi.org/10.1371/journal.pone.0209344>
#' @source \strong{Thailand}: Table 3 column 6 page 4 in Pattanaphesaj et al (2018) <doi:10.1080/14737167.2018>
#' @source \strong{Uruguay}: Table 2.3 column 5 page 29 in Augustovski et al (2016) <doi:10.1007/s11136-015-1086-4>
#' @source \strong{USA}: Table 2 column 2 page 939 in Pickard et al (2019) <doi:10.1016/j.jval.2019.02.009>
#' @source \strong{Vietnam}: Table 3 column 5 in Mai et al (2020) <doi:10.1007/s11136-020-02469-7>
"EQ5D5L_tariffs.df"


#' Probability matrix for the cross walk
#' @format A dataframe with 3124 rows and 243 columns
#' @source https://euroqol.org/wp-content/uploads/2018/02/EQ-5D-5L_Crosswalk_model_and__methodology2.pdf
#' @source Van Hout et al (2012) <doi: 10.1016/j.jval.2012.02.008>.
"Probability_matrix_crosswalk.df"

#' EQ-5D-3L index values (for each set of response of 3L) for different countries
#' @note: For testing purpose -not required by users
#' @note: VAS value for state 3333 was reported as -0.022, rather obtained -0.034 and needs to be checked with authors
#' @note: There were some implausible orderings and hard coded those only for Australian value sets
#' @format A  243 by 38 dataframe
#' @source \strong{Argentina}: TTO - Appendix A in Augustovski et al (2009) <doi:10.1111/j.1524-4733.2008.00468.x>
#' @source \strong{Argentina}: VAS - Appendix A in Augustovski et al (2009) <doi:10.1111/j.1524-4733.2008.00468.x>
#' @source \strong{Australia}: Supplementary in Viney et al (2011) <doi:10.1016/j.jval.2011.04.009>
#' @source \strong{Belgium}: VAS - Selected example page 209 in Cleemput et al (2010) <doi:10.1007/s10198-009-0167-0>
#' @source \strong{Brazil}: Appendix 1 in Santos et al (2016) <doi:10.1177/0272989X15613521>
#' @source \strong{Canada}: Supplementary material Table S2 in Bansback et al (2012) <https://doi.org/10.1371/journal.pone.0031115>
#' @source \strong{Chile}: Table 4 page 1139 in Zarate et al (2011) <doi:10.1016/j.jval.2011.09.002
#' @source \strong{China}: Supplementary materials Appendix 2 in Liu et al (2014) <doi:10.1016/j.jval.2014.05.007>
#' @source \strong{Denmark}: TTO - Appendix in Wittrup-Jensen et al (2009) <doi:10.1177/1403494809105287>
#' @source \strong{Denmark}: VAS -  Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Europe}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Finland}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{France}: Selected example  page 61 in Chevalier et al (2013) <doi:10.1007/s10198-011-0351-x>
#' @source \strong{Germany}: TTO - Selected examples Table 6 page 130 in Greiner et al (2005) <doi:10.1007/s10198-004-0264-z>
#' @source \strong{Germany}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Iran}: Selected example  page 173 in  Goudarzi et al (2019) <doi:10.1016/j.vhri.2019.01.007>
#' @source \strong{Italy}: Supplementary materials Appendix 2 in Scalone et al (2013) <http://dx.doi.org/10.1016/j.jval.2013.04.008>
#' @source \strong{Japan}: Tsuchiya et al (2002) <https://doi.org/10.1002/hec.673>
#' @source \strong{Korea}: Selected example page 1191 in Lee et al <doi:10.1111/j.1524-4733.2009.00579.x>
#' @source \strong{Malaysia}: VAS - Supplementary material Appendix 3 in Yusof et al (2019) <doi:10.1016/j.jval.2011.11.024>
#' @source \strong{Netherlands}: Lamers et al <doi:10.1002/hec.1124>
#' @source \strong{New Zealand}: VAS - Selected examples Table 7 column 5 page 542 in Devlin et al <doi:10.1002/hec.741>
#' @source \strong{Poland}: Table 6 page 294 in Golicki et al <https://doi.org/10.1111/j.1524-4733.2009.00596.x>
#' @source \strong{Portugal}: Supplementary Material 1 in Ferreira et al <doi:10.1007/s11136-013-0448-z>
#' @source \strong{Slovenia}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Singapore}: Selected examples in Nan Luo et al <doi:10.1007/s40273-014-0142-1>
#' @source \strong{Spain}: TTO- Badia et al (2001) <doi:10.1177/0272989X0102100102>
#' @source \strong{Spain}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{Sri Lanka}: Selected example page 1789 in  Kularatna et al (2015) <doi:10.1007/s11136-014-0906-2>
#' @source \strong{Sweden}: Supplementary Table 3 in Burström et al (2014) <doi:10.1007/s11136-013-0496-4>
#' @source \strong{Taiwan}: Table 3  page 703 in Lee et al (2013) <http://dx.doi.org/10.1016/j.jfma.2012.12.015> #'
#' @source \strong{Thailand}: Tongsiri et al (2011) <doi:10.1016/j.jval.2011.06.005>
#' @source \strong{Trinidad and Tobago}: Table 5 page 66 in Bailey et al (2016) <http://dx.doi.org/10.1016/j.vhri.2016.07.010>
#' @source \strong{UK} : TTO - Selected examples Table 3  page 1105 in Dolan et al (1997) <http://dx.doi.org/10.1097/00005650-199711000-00002>
#' @source \strong{UK}: VAS - Table 2.3 page 14 in Szende et al (2014) <doi:10.1007/978-94-007-7596-1>
#' @source \strong{USA}: Appendix 1 page 218 in Shaw et al (2005) <doi:10.1097/00005650-200503000-00003>
#' @source \strong{Zimbabwe}: Jelsma et al (2003) <https://doi.org/10.1186/1478-7954-1-11>
"EQ5D3L_indexvalues.df"


#' EQ-5D-5L index values
#' @note: For testing purpose -not required by users
#' @format A 3125 by 22 dataframe
#' @source \strong{Canada}: Selected example Table A3 in Xie et al (2016) <doi:10.1097/MLR.0000000000000447>
#' @source \strong{China}: Supplementary Material 1 in Luo et al (2017) <doi:10.1016/j.jval.2016.11.016>
#' @source \strong{England}: Selected example Table 3 page 18 and supporting information in Devlin et al (2018) <doi:10.1002/hec.3564>
#' @source \strong{Ethopia}: Table 3 column 8 page 12 and supporting information in Welie et al (2019) <doi:10.1016/j.vhri.2019.08.475>
#' @source \strong{France}: Table 3 column 2-6 page 12 and supporting information in Andrade et al (2020) <doi::10.1007/s40273-019-00876-4>
#' @source \strong{Germany}: Supplementary Material 1 in Ludwig et al (2018) <doi:10.1007/s40273-018-0615-8>
#' @source \strong{Hong Kong}: Selected examples Table 3 page 244 in Wong et al (2018) <doi:10.1007/s40271-017-0278-0>
#' @source \strong{Indonesia}: Selected examples page 1162 in Purba et al (2017) <doi:10.1007/s40273-017-0538-9>
#' @source \strong{Ireland}: Selected example Table 2 page 1348 in Hobbins et al (2016) <doi:10.1007/s40273-018-0690-x>
#' @source \strong{Japan}: Shiroiwa, et al (2016) <doi:10.1016/j.jval.2016.03.1834>
#' @source \strong{Korea}: Selected example page 1848 in Kim et al (2016) <doi:10.1007/s11136-015-1205-2>
#' @source \strong{Malaysia}: Shafie  et al (2019) <doi:10.1007/s40273-018-0758-7>
#' @source \strong{Netherlands}: Versteegh et al (2016) <doi:10.1016/j.jval.2016.01.003>
#' @source \strong{Poland}: Supplementary Material 3 in Golicki et al <doi:10.1007/s40273-019-00811-7>
#' @source \strong{Portugal}: Ferreira1 et al (2014) <doi:10.1007/s11136-019-02226-5>
#' @source \strong{Spain}: Selected examples in Table 1 in Ramos-Goñiet et al (2018) <https://doi.org/10.1016/j.jval.2017.10.023>
#' @source \strong{Taiwan}: Table 3 page 10 in Lin et al (2018)  <https://doi.org/10.1371/journal.pone.0209344>
#' @source \strong{Thailand}: Pattanaphesaj et al (2018) <doi:10.1080/14737167.2018>
#' @source \strong{Uruguay}: Augustovski et al (2016) <doi:10.1007/s11136-015-1086-4>
#' @source \strong{USA}: Pickard et al (2019) <doi:10.1016/j.jval.2019.02.009>
#' @source \strong{Vietnam}: Mai et al (2020) <doi:10.1007/s11136-020-02469-7>
"EQ5D5L_indexvalues.df"


#' EQ-5D-5L crosswalk value sets for 10 countries
#' @note: For testing purpose -not required by users
#' @source https://euroqol.org/eq-5d-instruments/eq-5d-5l-about/valuation-standard-value-sets/crosswalk-index-value-calculator/ (accessed on Aug 03,2019)
#' @source Van Hout et al (2012) <doi: 10.1016/j.jval.2012.02.008>.
#' @format A 3125 by 11 dataframe
"EQ5D5L_crosswalk_indexvalues.df"
