% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payoffs.R
\docType{class}
\name{payoff_rollup}
\alias{payoff_rollup}
\title{Roll-up of premiums payoff class}
\format{\code{\link{R6Class}} object.}
\usage{
payoff_rollup
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class providing a roll-up of premium payoff object. The payoff is the
maximum between the account value and the roll-up of the premium
at a given rate.
}
\section{Methods}{

 \describe{
  \item{\code{new}}{Initialize method.
   The arguments are a non negative scalar with the premium and a
   \code{\link{constant_parameters}} object with the roll-up rate.}
  \item{\code{set_premium}}{Stores the premium in a
   private field. The argument is a non negative scalar}
  \item{\code{get_premium}}{Returns the premium
  as non negative scalar}
  \item{\code{set_rate}}{Sets the roll-up rate into a private
  field. The argument is a \code{\link{constant_parameters}} object}
  \item{\code{get_payoff}}{Gets the payoff.
   The arguments are a \code{numeric} vector
   with the amounts and a vector of \code{\link{timeDate}} objects
   with the start and end dates to calculate the roll-up amount
   (see \bold{Examples})}
}
}

\examples{
rate <- constant_parameters$new(0.01)
premium <- 100
rollup <- payoff_rollup$new(premium, rate)
t1 <- timeDate::timeDate("2016-01-01")
t2 <- timeDate::timeDate("2016-12-31")
rollup$get_payoff(c(120,100), c(t1,t2))
}
\keyword{datasets}
