% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Constants.R
\docType{data}
\name{names.sidechain.atoms}
\alias{names.sidechain.atoms}
\title{Sidechain Atom Names}
\format{An object of class \code{character} of length 32.}
\usage{
names.sidechain.atoms
}
\description{
Sidechain atom names based on PDB atom naming conventions.
}
\details{
The 32 unique sidechain atom names. The first character is the
element and the second character is the Greek letter (B=beta, D=delta,
E=epsilon, G=gamma, Z=zeta) defining the specific position within the
sidechain. The exception to the use of Greek letters is \code{OH}
indicating a hydroxyl group at the \emph{para} position of the six-member
ring of tyrosine. Some sidechain atom names have a number in the third
character position when there are mirrored/symetrical atoms; \emph{e.g.},
\code{CG1} and \code{CG2} of valine.
}
\examples{
  names.sidechain.atoms
  # [1] "CB"  "CG"  "CD"  "NE"  "CZ"  "NH1" "NH2" "OD1" "ND2" "OD2" "SG"
  #     "OE1" "NE2" "OE2" "CD2" "ND1" "CE1" "CG1" "CG2" "CD1" "CE"  "NZ"
  #     "SD"  "CE2" "OG"  "OG1" "NE1" "CE3" "CZ2" "CZ3" "CH2" "OH"

}
\seealso{
Other constants: \code{\link{names.backbone.atoms}},
  \code{\link{names.polar.atoms}},
  \code{\link{names.res.AtomTypes}},
  \code{\link{names.resATs.carb.sulf}},
  \code{\link{names.resATs.nitro.neut}},
  \code{\link{names.resATs.nitro.pos}},
  \code{\link{names.resATs.oxy.neg}},
  \code{\link{names.resATs.oxy.neut}},
  \code{\link{names.residues}}, \code{\link{names.waters}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\keyword{datasets}
