% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z.test.R
\name{z.test}
\alias{z.test}
\title{Simplified Z Tests}
\usage{
z.test(df, var1, var2, prop)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{variable with the total number of events, by sub-unit (e.g. cities within a county).}

\item{var2}{variable with number of events for a specific group.}

\item{prop}{proportion to compare to (between 0 and 1).}
}
\value{
This function returns the Z score and p-value for the z-test.
}
\description{
This function runs a one-sample Z-test, comparing the proportion in your sample to the proportion in the population.
}
\examples{
data <- UCR2015[UCR2015$state=="California",]
data$total_part2 <- data$burglary + data$larceny + data$mv_theft + data$arson

z.test(data,total_part2,burglary,.25)
}
