\name{plot.varirf}

\alias{plot.varirf}

\encoding{latin1}

\title{Plot method for objects of class varirf}

\description{
  Plots of the impulse response functions per impulse variable.
}

\usage{
\method{plot}{varirf}(x, ...)
}

\arguments{
  \item{x}{An object of class \sQuote{\code{varirf}}, generated by
    \command{irf()}.}
  \item{\dots}{Currently not used.}
}

\author{Bernhard Pfaff}

\references{
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Ltkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York. 
}
\seealso{
  \code{\link{irf}}
}

\examples{
\dontrun{
data(Canada)
var.2c <- VAR(Canada, p = 2, type = "const")
var.2c.irf <- irf(var.2c, impulse = "e", response = c("prod", "rw",
"U"), boot = FALSE)
plot(var.2c.irf)
}
}

\keyword{regression}
