% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotype_matrix_functions.R
\name{Genotype matrix functions}
\alias{Genotype matrix functions}
\alias{alleles2consensus}
\alias{get.alleles}
\title{Genotype matrix functions}
\usage{
alleles2consensus(x, sep = "/", NA_to_n = TRUE)

get.alleles(x2, split = "/", na.rm = FALSE, as.numeric = FALSE)
}
\arguments{
\item{x}{a matrix of alleles as genotypes (e.g., A/A, C/G, etc.)}

\item{sep}{a character which delimits the alleles in a genotype (/ or |)}

\item{NA_to_n}{logical indicating whether NAs should be scores as n}

\item{x2}{a vector of genotypes}

\item{split}{character passed to strsplit to split the genotype into alleles}

\item{na.rm}{logical indicating whether to remove NAs}

\item{as.numeric}{logical specifying whether to convert to a numeric}
}
\description{
Functions which modify a matrix or vector of genotypes.
}
\details{
The function \strong{alleles2consensus} converts genotypes to a single consensus allele using IUPAC ambiguity codes for heterozygotes. 
Note that some functions, such as ape::seg.sites do not recognize ambiguity characters (other than 'n').
This means that these functions, as well as functions that depend on them (e.g., pegas::tajima.test), will produce unexpected results.

Missing data are handled in a number of steps.
When both alleles are missing ('.') the genotype is converted to NA.
Secondly, if one of the alleles is missing ('.') the genotype is converted to NA>
Lastly, NAs can be optionally converted to 'n' for compatibility with DNAbin objects.

The function \strong{get.alleles} takes a vector of genotypes and returns the unique alleles.
}

