% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFO2df.R
\name{INFO2df}
\alias{INFO2df}
\alias{metaINFO2df}
\title{Reformat INFO data as a data.frame}
\usage{
INFO2df(x)

metaINFO2df(x, field = "INFO")
}
\arguments{
\item{x}{an object of class vcfR or chromR.}

\item{field}{should either the INFo or FORMAT data be returned?}
}
\value{
A data.frame
}
\description{
Reformat INFO data as a data.frame and handle class when possible.
}
\details{
The INFO column of VCF data contains descriptors for each variant.
Because this column may contain many comma delimited descriptors it may be difficult to interpret.
The function INFO2df converts the data into a data.frame.
The function metaINFO2df extracts the information in the meta section that describes the INFO descriptors.
This function is called by INFO2df to help it handle the class of the data.
}
\examples{
data(vcfR_test)
metaINFO2df(vcfR_test)
getINFO(vcfR_test)
INFO2df(vcfR_test)


}

