% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_line}
\alias{v_line}
\title{Create a Line Chart}
\usage{
v_line(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  line = list(style = list(curveType = "linear", lineDash = 0, stroke = NULL)),
  point = list(visible = FALSE),
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{line}{Line's options, such as curve interpolation type,
see \href{https://www.visactor.io/vchart/option/lineChart#line.style.curveType}{online documentation}}

\item{point}{Options for showing points on lines or not.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Line Chart
}
\examples{

library(vchartr)

# Basic Line Chart
vchart(eco2mix) \%>\% 
  v_line(aes(date, solar))

# Two lines
vchart(tail(eco2mix, 30), aes(date)) \%>\% 
  v_line(aes(y = solar)) \%>\% 
  v_line(aes(y = wind))

# Line chart with discrete x axis
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\% 
  v_line(aes(month, value))

# Stroke color 
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\% 
  v_line(
    aes(month, value),
    line = list(style = list(stroke = "firebrick"))
  )

# Smooth Line Chart
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\% 
  v_line(
    aes(month, value), 
    line = list(style = list(curveType = "monotone"))
  )

# Step Line Chart
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\% 
  v_line(
    aes(month, value),
    line = list(style = list(curveType = "stepAfter"))
  )

# Dash array 
vchart(data.frame(month = month.abb, value = sample(1:50, 12))) \%>\% 
  v_line(
    aes(month, value),
    line = list(style = list(lineDash = c(10, 10)))
  )

# Multiple lines
vchart(eco2mix_long) \%>\% 
  v_line(aes(date, production, color = source))

}
