% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_crosshair}
\alias{v_specs_crosshair}
\title{Add crosshair to chart}
\usage{
v_specs_crosshair(vc, ...)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{...}{Options for the legend, see examples or
\href{https://www.visactor.io/vchart/option/commonChart#crosshair}{online documentation}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Add crosshair to chart
}
\examples{

library(vchartr)

data.frame(month = month.abb, value = sample(1:50, 12)) \%>\% 
  vchart() \%>\% 
  v_line(aes(month, value)) \%>\% 
  v_specs_crosshair(
    xField = list(
      visible = TRUE,
      line = list(type = "rect"), 
      defaultSelect = list(
        axisIndex = 0, 
        datum = "May"
      ), 
      label = list(visible = TRUE)
    ), 
    yField = list(
      visible = TRUE, 
      defaultSelect = list(
        axisIndex = 1,
        datum = 30
      ), 
      line = list(
        style = list(
          lineWidth = 1, 
          opacity = 1, 
          stroke = "#000", 
          lineDash = c(2, 2)
        )
      ),
      label = list(visible = TRUE)
    )
  )

}
