% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.agree}
\alias{meta.ave.agree}
\title{Confidence interval for an average G-index agreement coefficient}
\usage{
meta.ave.agree(alpha, f11, f12, f21, f22, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequencies in cell 1,1}

\item{f12}{vector of frequencies in cell 1,2}

\item{f21}{vector of frequencies in cell 2,1}

\item{f22}{vector of frequencies in cell 2,2}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate
across all studies.  If bystudy is true, there is 1 additional row for
each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
G-index of agreement from two or more studies. This function assumes
that two raters each provide a dichotomous rating to a sample of objects.
The G-index of agreement is usually preferred to Cohen's kappa.
}
\examples{
f11 <- c(17, 28, 19)
f12 <- c(43, 56, 49)
f21 <- c(3, 5, 5)
f22 <- c(37, 54, 39)
meta.ave.agree(.05, f11, f12, f21, f22, bystudy = TRUE)

# Should return:
#           Estimate         SE          LL        UL
# Average 0.08657934 0.05312584 -0.01754538 0.1907041
# Study 1 0.07692308 0.09776752 -0.11469775 0.2685439
# Study 2 0.14285714 0.08163265 -0.01713992 0.3028542
# Study 3 0.03448276 0.09279245 -0.14738711 0.2163526


}
