\encoding{UTF-8}
\name{adonis}
\alias{adonis}
\alias{print.adonis}

\title{Multivariate Analysis of Variance Using Distance Matrices }

\description{ Analysis of variance using distance matrices --- for partitioning distance
matrices among sources of variation and fitting linear models to
distance matrices.  }

\usage{
adonis(formula, data, permutations = 5, method = "bray", strata = NULL,
     contr.unordered = "contr.sum", contr.ordered = "contr.poly")
}

\arguments{
  \item{formula}{a typical model formula such as \code{Y ~ A + B*C}, but
    where \code{Y} is a data frame or a matrix; \code{A}, \code{B}, and
    \code{C} may be factors or continuous variables. } 
  \item{data}{ the data frame from which \code{A}, \code{B}, and
    \code{C} would be drawn.} 
  \item{permutations}{ number of replicate permutations used for the
    hypothesis tests (\eqn{F} tests).} 
  \item{method}{ the name of any method used in \code{\link{vegdist}} to
    calculate pairwise distances. } 
  \item{strata}{ groups (strata) within which to constrain permutations.  }
  \item{contr.unordered, contr.ordered}{contrasts used for the design
    matrix (default in R is dummy or treatment contrasts for unordered
    factors). } 
}

\details{\code{adonis} is a function for the analysis and partitioning
sums of squares using semimetric and metric distance matrices. Insofar
as it partitions sums of squares of a multivariate data set, it is
directly analogous to MANOVA (multivariate analysis of
variance). McArdle and Anderson (2001) and Anderson (2001) refer to the
method as \dQuote{nonparametric manova}. Further, as its inputs are
linear predictors, and a response matrix of an arbitrary number of
columns (2 to millions), it is a robust alternative to both parametric
MANOVA and to ordination methods for describing how variation is
atributed to different experimental treatments or uncontrolled
covariates. It is also analogous to redundancy analysis (Legendre and
Anderson 1999).

Typical uses of \code{adonis} include analysis of ecological community
data (samples X species matrices) or genetic data where we might have a
limited number of samples of individuals and thousands or millions of
columns of gene expression data (e.g. Zapala and Schork 2006).

\code{adonis} is an alternative to AMOVA (nested analysis of molecular
variance, Excoffier, Smouse, and Quattro, 1992;
\code{\link[ade4]{amova}} in the \pkg{ade4} package) for both crossed
and nested factors.

Like AMOVA (Excoffier et al. 1992), \code{adonis} relies on a
long-understood phenomenon that allows one to partition sums of squared
deviations from a centroid in two different ways (McArdle and Anderson
2001). The most widely recognized method, used, e.g., for ANOVA and
MANOVA, is to first identify the relevant centroids and then to
calculated the squared deviations from these points. For a centered
\eqn{n \times p}{n x p} response matrix \eqn{Y}, this method uses the
\eqn{p \times p}{p x p} inner product matrix \eqn{Y'Y}. The less
appreciated method is to use the \eqn{n \times n}{n x n} outer product
matrix \eqn{YY'}. Both AMOVA and \code{adonis} use this latter
method. This allows the use of any semimetric (e.g. Bray-Curtis, aka
Steinhaus, Czekanowski, and \enc{Sørensen}{Sorensen}) or metric
(e.g. Euclidean) distance matrix (McArdle and Anderson 2001). Using
Euclidean distances with the second method results in the same analysis
as the first method.

Significance tests are done using \eqn{F}-tests based on sequential sums
of squares from permutations of the raw data. Additional work should be
done to validate these methods; preliminary work suggests substantive
differences between permutations of the raw data versus permutations of
the residuals. Further, the precise meaning of hypothesis tests will
depend upon precisely what is permuted. The strata argument keeps groups
intact for a particular hypothesis test where one does not want to
permute the data among particular groups. For instance, \code{strata =
B} causes permutations among levels of \code{A} but retains data within
levels of \code{B} (no permutation among levels of \code{B}).

The default \code{\link{contrasts}} are different than in \R in
general. Specifically, they use \dQuote{sum} contrasts, sometimes known
as \dQuote{ANOVA} contrasts. See a useful text (e.g. Crawley,
2002) for a transparent introduction. This is simply a personal
pedagogical preference. The particular contrasts can be set to any
\code{\link{contrasts}} specified in \R, including Helmert and treatment
contrasts.

Rules associated with formulae apply. See "An Introduction to R" for an
overview of rules.

\code{print.adonis} shows the \code{aov.tab} component of the output.
}
\value{
  This function returns typical, but limited, output for analysis of
  variance (general linear models). 

  \item{aov.tab }{Typical AOV table showing sources of variation,
    degrees of freedom, sequential sums of squares, mean squares,
    \eqn{F} statistics, partial R-squared and \eqn{P} values, based on \eqn{N}
    permutations. }
  \item{coefficients }{ matrix of coefficients of the linear model, with
    rows representing sources of variation and columns representing
    species. } 
  \item{f.perms}{ an \eqn{N} by \eqn{m} matrix of the null \eqn{F} statistics for each
    source of variation  based on \eqn{N} permutations of the data. }  
}
\references{
Anderson, M.J. 2001. A new method for non-parametric multivariate
analysis of variance. \emph{Austral Ecology}, 26: 32--46.

Crawley, M.J. 2002. \emph{Statistical Computing: An Introduction to Data
  Analysis Using S-PLUS} 

Excoffier, L., P.E. Smouse, and J.M. Quattro. 1992. Analysis of
molecular variance inferred from metric distances among DNA haplotypes:
Application to human mitochondrial DNA restriction data. \emph{Genetics},
131:479--491.

Legendre, P. and M.J. Anderson. 1999. Distance-based redundancy
analysis: Testing multispecies responses in multifactorial ecological
experiments. \emph{Ecological Monographs}, 69:1--24.

McArdle, B.H.  and M.J. Anderson. 2001. Fitting multivariate models to
community data: A comment on distance-based redundancy
analysis. \emph{Ecology}, 82: 290--297.

Zapala, M.A. and N.J. Schork. 2006. Multivariate regression analysis of
distance matrices for testing associations between gene expression
patterns and related variables. \emph{Proceedings of the National Academy of
Sciences, USA}, 103:19430--19435.
}
\author{Martin Henry H. Stevens
\email{HStevens@muohio.edu},
  adapted to \pkg{vegan} by Jari Oksanen. }

\seealso{ \code{\link{mrpp}}, \code{\link{anosim}},
  \code{\link{mantel}}, \code{\link{varpart}}. }
\examples{
data(dune)
data(dune.env)
adonis(dune ~ Management*A1, data=dune.env, permutations=100)
}

\keyword{multivariate }
\keyword{nonparametric }
