% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_project.R
\name{get_project}
\alias{get_project}
\title{Download vein project}
\usage{
get_project(directory, case = "brasil", url)
}
\arguments{
\item{directory}{Character; Path to an existing or a new directory to be created.}

\item{case}{Character; One of  of the following:
\tabular{llll}{
  \strong{case}       \tab \strong{Description}\tab  \strong{EF} \tab \strong{Outputs}   \cr
  brazil or brazil_bu or brasil or brasil_bu\tab Bottom-up \tab CETESB \tab  .rds\cr
  emislacovid         \tab Bottom-up March 2020\tab CETESB \tab  .rds\cr
  brazil_bu_csvgz     \tab Bottom-up \tab CETESB+tunnel \tab  .csv.gz\cr
  brazil_csv         \tab Bottom-up. Faster but heavier\tab CETESB\tab  .csv\cr
  brazil_td_chem      \tab Top-down with chemical mechanisms\tab CETESB\tab  .csv and .rds\cr
  brazil_bu_chem      \tab Bottom-up  chemical mechanisms\tab CETESB+tunnel\tab  .rds\cr
  brazil_bu_chem_streets      \tab Bottom-up  chemical mechanisms for streets and MUNICH\tab CETESB+tunnel\tab  .rds\cr
  brazil_td_chem_im      \tab Top-down with chemical mechanisms+IM\tab CETESB\tab  .csv and .rds\cr
  brazil_bu_chem_im      \tab Bottom-up  chemical mechanisms+IM\tab CETESB+tunnel\tab  .rds\cr
  brazil_bu_chem-month  \tab Bottom-up  chemical mechanisms\tab CETESB+tunnel\tab  .rds\cr
  brazil_bu_chem_streets_im      \tab Bottom-up  chemical mechanisms for streets and MUNICH+IM\tab CETESB+tunnel\tab  .rds\cr
  sebr_cb05co2      \tab Top-down SP, MG and RJ\tab CETESB+tunnel\tab  .rds\cr
  amazon2014      \tab Top-down Amazon\tab CETESB+tunnel\tab  csv and.rds\cr
  curitiba      \tab Bottom-down +GTFS\tab CETESB+tunnel\tab  csv and.rds\cr
  masp2020      \tab Bottom-down\tab CETESB+tunnel\tab  csv and.rds\cr
  ecuador_td      \tab Top-down\tab EEA\tab  csv and.rds\cr
  ecuador_td_im      \tab Top-down\tab EEA\tab  csv and.rds\cr
  ecuador_td_hot      \tab Top-down\tab EEA\tab  csv and.rds\cr
  ecuador_td_hot_month      \tab Top-down\tab EEA\tab  csv and.rds\cr
  moves_bu      \tab Bottom-up\tab US/EPA MOVES \tab  csv and.rds (requires MOVES >=3.0 on Windows)\cr
  manizales_bu      \tab Bottom-up  chemical mechanisms\tab EEA\tab  csv, csv.gz, .rds\cr
  sebr_cb05co2_im  \tab Top-down SP, MG and RJ IM\tab CETESB+tunnel\tab  .rds\cr
  eu_bu_chem      \tab Bottom-up  chemical mechanisms\tab EEA 2019\tab  .rds\cr
  eu_bu_chem_simple \tab Bottom-up  chemical mechanisms 7 veh\tab EEA 2019\tab  .rds\cr
}}

\item{url}{String, with the URL to download VEIN project}
}
\description{
\code{\link{get_project}} downloads a project for running vein.
The projects are available on Github.com/atmoschem/vein/projects
}
\note{
default case can be any of "brasil", "brazil", "brazil_bu", "brasil_bu", they are
the same
In any case, if you find any error, please, send a pull request in github.

In Sao Paulo the IM programs was functioning until 2011.
}
\examples{
\dontrun{
#do not run
get_project("awesomecity")
}

}
