% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_whe.R
\name{ef_whe}
\alias{ef_whe}
\title{Emission factor that incorporates the effect of high emitters}
\usage{
ef_whe(efhe, phe, ef)
}
\arguments{
\item{efhe}{Numeric; Emission factors of high emitters vehicles. This vehicles
would be rejected in a inspection and mantainnence program.}

\item{phe}{Numeric; Percentage of high emitters.}

\item{ef}{Numeric; Emission factors deteriorated vehicles under normal
conditions. These vehicles would be approved in a inspection and mantainence
program.}
}
\value{
An emission factor by annual mileage.
}
\description{
\code{\link{ef_whe}} return weighted emission factors of vehicles considering
that one part of the fleet has a normal deterioration and another has a
deteriorated fleet that would be rejected in a inspection and mantainence
program but it is still in circulation. This emission factor might be
applicable in cities without a inspection and mantainence program and with
Weighted emission factors considering that part of the fleet are high emitters.
}
\examples{
\dontrun{
# Do not run
# Let's say high emitter is 5 times the normal ef.
co_efhe <- ef_cetesb(p = "COd", "PC_G") * 5
# Let's say that the perfil of high emitters increases linearly
# till 30 years and after that percentage is constant
perc <- c(seq(0.01, 0.3, 0.01), rep(0.3, 20))
# Now, lets use our ef with normal deterioration
co_ef_normal <- ef_cetesb(p = "COd", "PC_G")
efd <- ef_whe(efhe = co_efhe, phe = perc, ef = co_ef_normal)
# now, we can plot the three ef
plot(co_efhe)
lines(co_ef_normal, pch = 16, col = "red" )
lines(efd, pch = 16, col = "blue")
}
}
\keyword{emission}
\keyword{emitters}
\keyword{factors}
\keyword{high}
