% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_china.R
\name{ef_china_speed}
\alias{ef_china_speed}
\title{Correction of Chinese emission factors by speed}
\usage{
ef_china_speed(speed, f = "G", standard, p, long = FALSE)
}
\arguments{
\item{speed}{numeric speed km/h}

\item{f}{Character;fuel: "G", "D", "CNG"}

\item{standard}{Character vector; "PRE", "I", "II", "III", "IV", "V".}

\item{p}{Character; pollutant: "CO", "NOx","HC", "PM", "Evaporative_driving"
or "Evaporative_parking"}

\item{long}{Logical, to process long format of ef}
}
\value{
long data.frame
}
\description{
Correction of Chinese emission
}
\examples{
{
data(net)
head(ef_china_speed(speed = net$ps, standard = "I", p = "CO"))
head(ef_china_speed(speed = net$ps,
                    standard = c("II", "I"),
                    p = "NOx"))
}
}
\seealso{
Other China: 
\code{\link{ef_china_det}()},
\code{\link{ef_china_hu}()},
\code{\link{ef_china_h}()},
\code{\link{ef_china_long}()},
\code{\link{ef_china_s}()},
\code{\link{ef_china_te}()},
\code{\link{ef_china_th}()},
\code{\link{ef_china}()},
\code{\link{emis_china}()},
\code{\link{emis_long}()}
}
\concept{China}
