% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundanceMatrix.R
\name{abundanceMatrix}
\alias{abundanceMatrix}
\title{Create a community matrix of taxon abundances.}
\usage{
abundanceMatrix(Data, Rows = "geoplate", Columns = "genus")
}
\arguments{
\item{Data}{A data.frame of taxonomic occurrences. Must have at least two columns. One column representing the samples, and one column representing the taxa.}

\item{Rows}{A characer string}

\item{Columns}{A character string}
}
\value{
A numeric matrix of taxon abundances. Samples as the rownames and species as the column names.
}
\description{
Creates a community matrix of taxon abundances, with samples as rows and species as columns, from a data frame.
}
\examples{

# Download a test dataset of pleistocene bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia", StartInterval="Pleistocene", StopInterval="Pleistocene")

# Clean the genus column
# DataPBDB<-cleanTaxonomy(DataPBDB,"genus")

# Create a community matrix of genera by tectonic plate id#
# CommunityMatrix<-abundanceMatrix(Data=DataPBDB, Rows="geoplate", Columns="genus")

}
\author{
Andrew A. Zaffos
}

