% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_cast.R
\name{VeloxRaster_as.matrix}
\alias{VeloxRaster_as.matrix}
\title{Cast a VeloxRaster band as a matrix}
\arguments{
\item{band}{Integer indicating the VeloxRaster band to be transformed.}
}
\value{
A matrix.
}
\description{
\code{as.matrix} creates a matrix from a VeloxRaster band.
}
\examples{
## Make VeloxRaster
mat <- matrix(1:100, 10, 10)
vx <- velox(mat, extent=c(0,1,0,1), res=c(0.1,0.1), crs="+proj=longlat +datum=WGS84 +no_defs")
## Cast to matrix
vx.mat <- vx$as.matrix(band=1)
identical(mat, vx.mat)

}

