% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr-predict.R
\name{vetiver_pr_predict}
\alias{vetiver_pr_predict}
\title{Create a Plumber API to predict with a deployable \code{vetiver_model()} object}
\usage{
vetiver_pr_predict(
  pr,
  vetiver_model,
  path = "/predict",
  debug = is_interactive(),
  ...
)
}
\arguments{
\item{pr}{A Plumber router, such as from \code{\link[plumber:pr]{plumber::pr()}}.}

\item{vetiver_model}{A deployable \code{\link[=vetiver_model]{vetiver_model()}} object}

\item{path}{The endpoint path}

\item{debug}{\code{TRUE} provides more insight into your API errors.}

\item{...}{Other arguments passed to \code{predict()}, such as prediction \code{type}}
}
\value{
A Plumber router with the prediction endpoint added.
}
\description{
Use \code{vetiver_pr_predict()} to add a POST endpoint for predictions from a
trained, pinned \code{\link[=vetiver_model]{vetiver_model()}} to a Plumber router.
}
\details{
First store and version your \code{\link[=vetiver_model]{vetiver_model()}} with
\code{\link[=vetiver_pin_write]{vetiver_pin_write()}}, and then create an API endpoint with
\code{vetiver_pr_predict()}.

Setting \code{debug = TRUE} may expose any sensitive data from your model in
API errors.
}
\examples{

cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")

library(plumber)
pr() \%>\% vetiver_pr_predict(v)
## next, pipe to `pr_run()`

}
