% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{predict.vetiver_endpoint}
\alias{predict.vetiver_endpoint}
\title{Post new data to a deployed model API endpoint and return predictions}
\usage{
\method{predict}{vetiver_endpoint}(object, new_data, ...)
}
\arguments{
\item{object}{A model API endpoint object created with \code{\link[=vetiver_endpoint]{vetiver_endpoint()}}.}

\item{new_data}{New data for making predictions, such as a data frame.}

\item{...}{Extra arguments passed to \code{\link[httr:POST]{httr::POST()}}}
}
\value{
A tibble of model predictions with as many rows as in \code{new_data}.
}
\description{
Post new data to a deployed model API endpoint and return predictions
}
\examples{

if (FALSE) {
endpoint <- vetiver_endpoint("http://127.0.0.1:8088/predict")
predict(endpoint, mtcars[4:7, -1])
}


}
\seealso{
\code{\link[=augment.vetiver_endpoint]{augment.vetiver_endpoint()}}
}
