% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_slope.R
\name{add_slope}
\alias{add_slope}
\title{Put slope back into data}
\usage{
add_slope(data)
}
\arguments{
\item{data}{a LAS of a TLS scene from which the slope was previously removed.}
}
\value{
a LAS with slope.
}
\description{
Reverse the result of the \code{\link[viewshed3d]{remove_slope}} function.
}
\examples{
\donttest{
#- import the tree_line_plot dataset
file <- system.file("extdata", "tree_line_plot.laz", package="viewshed3d")
tls <- lidR::readLAS(file)

center <- c(0,0,2) # defines the scene center for the entire process
angle <- 1 # defines the angular resolution for the entire process

#- remove noise to avoid visibility estimates error
tls_clean <- viewshed3d::denoise_scene(tls,method="sd",
                                       filter=6)


#- class ground and vegetation points
class <- lidR::classify_ground(tls_clean, lidR::csf(rigidness = 1L,
                                                 class_threshold = 0.2,
                                                 sloop_smooth = FALSE))


# remove the slope from the classified scene
no_slope <- viewshed3d::remove_slope(data = class,c(0,0,0))

# add the slope
slope_back <- viewshed3d::add_slope(no_slope$data)
}
}
