% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_slope.R
\name{remove_slope}
\alias{remove_slope}
\title{Removes the slope from a TLS scene}
\usage{
remove_slope(data, position)
}
\arguments{
\item{data}{LAS class object containing the xyz coordinates of a 3D point
cloud with segmented ground and non-ground points.}

\item{position}{vector of length 3 containing the xyz coordinates of the
animal location. Default = c(0,0,0).}
}
\value{
The LAS of the TLS scene without slope and the new animal position. Note
that in the LAS, the original coordinates are stored.
}
\description{
Removes the slope from a TLS scene by fitting a plan to the ground
points and rotating the scene according to the plan orientation. Note that the
animal position is also rotated so the relative position remain unchanged.
}
\examples{
\donttest{
#- import the tree_line_plot dataset
file <- system.file("extdata", "tree_line_plot.laz", package="viewshed3d")
tls <- lidR::readLAS(file)

center <- c(0,0,2) # defines the scene center for the entire process
angle <- 1 # defines the angular resolution for the entire process

#- remove noise to avoid visibility estimates error
tls_clean <- viewshed3d::denoise_scene(tls,method="sd",
                                       filter=6)


#- class ground and vegetation points
class <- lidR::classify_ground(tls_clean, lidR::csf(rigidness = 1L,
                                                 class_threshold = 0.2,
                                                 sloop_smooth = FALSE))


# remove the slope from the classified scene
no_slope <- viewshed3d::remove_slope(data = class,c(0,0,0))

# plot the data with slope
lidR::plot(class,axis = TRUE)

# plot the data vithout slope
lidR::plot(no_slope$data,axis = TRUE)

# compute visibility from the data without slope
view.data <- viewshed3d::visibility(data = no_slope$data,
                                    position = no_slope$position,
                                    angular_res = angle,
                                    scene_radius = 17, # apply cut_oof distance
                                    store_points = TRUE)
}
}
