% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/violinPoint.R
\name{number2digits}
\alias{number2digits}
\title{Convert an integer to an arbitrary base}
\usage{
number2digits(n, base = 2)
}
\arguments{
\item{n}{the integer to be converted}

\item{base}{the base for the numeral system (e.g. 2 for binary or 8 for octal)}
}
\value{
a vector of length ceiling(log(n+1,base)) respresenting each digit for that numeral system
}
\description{
Takes an integer and converts it into an arbitrary base e.g. binary or octal. Note that the first digit in the output is the least significant.
}
\examples{
number2digits(100)
number2digits(100,8)
}
\references{
\url{https://en.wikipedia.org/wiki/Radix}
}

