% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualPollen.R
\docType{data}
\name{drivers}
\alias{drivers}
\title{Drivers with different temporal autocorrelation.}
\format{
Dataframe with 4 columns and 20000 rows.
}
\usage{
data(drivers)
}
\description{
A dataframe with 20000 rows and 4 columns (years) containing two drivers (A and B) generated by \code{\link{simulateDriver}} with different temporal autocorrelations (200 and 600). Each driver represents a period of 5000 years. This dataset is is meant to be used as input for \code{\link{simulatePopulation}}
}
\details{
\itemize{
  \item \emph{time} integer, represents time from 0 to 10000, \strong{where 0 is the oldest sample, and 10000 is the newest one (opposite to the general interpretation of age in palaeoecology!)}.
  \item \emph{driver} character, values are \code{A} and \code{B}
  \item \emph{autocorrelation.length} numeric, values are 200, 600, and 1800.
  \item \emph{value} numeric, value of the driver for the given \code{time}, \emph{driver}, and \emph{autocorrelation.length}.
}
}
\seealso{
\code{\link{simulateDriver}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\keyword{datasets}
