% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pvalue.R
\name{get_pvalue}
\alias{get_pvalue}
\title{Summarize the test for equality across strata from a survival object using S3 method}
\usage{
get_pvalue(
  survfit_object,
  ptype = "All",
  rho = NULL,
  statlist = c("test", "Chisq", "df", "pvalue"),
  ...
)
}
\arguments{
\item{survfit_object}{An object of class \code{survfit}}

\item{ptype}{Character vector containing the type of p-value desired. Current options are "Log-Rank" "Wilcoxon" "Tarone-Ware" "Custom" "All".
"Custom" allows the user to specify the weights on the Kaplan-Meier estimates using the argument \code{rho}.
The default is "All" displaying all types possible. When \code{rho} is specified in context of "All", also a custom p-value is displayed.}

\item{rho}{
a scalar parameter that controls the type of test.
}

\item{statlist}{Character vector containing the desired information to be displayed. The order of the arguments determines the order in which
they are displayed in the final result. Default is the test name ("test"), Chi-squared test statistic ("Chisq"), degrees of freedom ("df") and
p-value ("pvalue").}

\item{...}{other arguments passed on to the method}
}
\value{
A data frame with summary measures for the Test of Equality Across Strata
}
\description{
Wrapper around survival::survdiff that tests the null hypothesis of equality across strata.
}
\examples{

## general examples
survfit_object <- visR::estimate_KM(data = adtte, strata = "TRTP")
visR::get_pvalue(survfit_object)
visR::get_pvalue(survfit_object, ptype = "All")

## examples to obtain specific tests
visR::get_pvalue(survfit_object, ptype = "Log-Rank")
visR::get_pvalue(survfit_object, ptype = "Wilcoxon")
visR::get_pvalue(survfit_object, ptype = "Tarone-Ware")

## Custom example - obtain Harrington and Fleming test
visR::get_pvalue(survfit_object, ptype = "Custom", rho = 1)

## Get specific information and statistics
visR::get_pvalue(survfit_object, ptype = "Log-Rank", statlist = c("test", "Chisq", "df", "pvalue"))
visR::get_pvalue(survfit_object, ptype = "Wilcoxon", statlist = c("pvalue"))

}
\seealso{
\code{\link[survival]{survdiff}}
}
