% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IV_report.R
\name{IV_report}
\alias{IV_report}
\title{Generate a Information Value HTML Report}
\usage{
IV_report(
  data,
  predictors = NULL,
  outcome,
  bins = 5,
  max_var = 9,
  path = "IV report",
  timestamp = TRUE
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{predictors}{A character vector specifying the columns to be used as
predictors. Defaults to NULL, where all numeric vectors in the data will be
used as predictors.}

\item{outcome}{A string specifying a binary variable, i.e. can only contain
the values 1 or 0.}

\item{bins}{Number of bins to use in \code{Information::create_infotables()},
defaults to 10.}

\item{max_var}{Numeric value to represent the maximum number of variables to
show on plots.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. For example, \code{"IV report"}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to TRUE.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
The function generates an interactive HTML report using Standard Person Query
data as an input. The report contains a full Information Value analysis,  a
data exploration technique that helps determine which columns in a data set
have predictive power or influence on the value of a specified dependent
variable.
}
\section{Creating a report}{


Below is an example on how to run the report.

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(dplyr)

pq_data \%>\%
  mutate(CH_binary = ifelse(Collaboration_hours > 12, 1, 0)) \%>\% # Simulate binary variable
  IV_report(outcome =  "CH_binary",
            predictors = c("Email_hours", "Meeting_hours"))
}\if{html}{\out{</div>}}
}

\seealso{
Other Reports: 
\code{\link{generate_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{validation_report}()}

Other Variable Association: 
\code{\link{create_IV}()}

Other Information Value: 
\code{\link{create_IV}()}
}
\concept{Information Value}
\concept{Reports}
\concept{Variable Association}
