% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Vmd.R
\docType{data}
\name{vmd}
\alias{R6Vmd}
\alias{as.data.frame.vmd}
\alias{plot.vmd}
\alias{vmd}
\title{Create VMD Object}
\usage{
vmd(signal, alpha = getOption("vmd.alpha"), tau = getOption("vmd.tau"),
  K = getOption("vmd.K"), DC = getOption("vmd.DC"),
  init = getOption("vmd.init"), tol = getOption("vmd.tol"), ...)
}
\arguments{
\item{signal}{the time domain signal (1D) to be decomposed}

\item{alpha}{the balancing parameter of the data-fidelity constraint}

\item{tau}{time-step of the dual ascent (pick 0 for noise-slack)}

\item{K}{the number of modes to be recovered}

\item{DC}{true if the first mode is put and kept at DC (0-freq)}

\item{init}{0 = all omegas start at 0, 1 = all omegas start uniformly distributed or 2 = all omegas initialized randomly}

\item{tol}{tolerance of convergence criterion, typically around 1e-6}

\item{...}{any other arguments to be passed to the R6 initializer}
}
\description{
Create instance of \code{R6Vmd}, which is an R6 implementation, ported from the original 2013 Matlab
code developed by Dragomiretskiy & Zosso.
}
\examples{
x = seq(-2*pi,2*pi,length.out=1000)
signal = cos(x)
v = vmd(signal,DC=FALSE,tol=1e-3)
v$getResult()
plot(v)

nv   = 1000
fs   = 1/nv
t    = (1:nv)/nv
freq = 2*pi*(1 - 0.5 - 1/nv)/fs
f_1 = 2;
f_2 = 24;
f_3 = 288;
f_4 = 12;
v_1 = (cos(2*pi*f_1*t));
v_2 = 1/4*(cos(2*pi*f_2*t));
v_3 = 1/16*(cos(2*pi*f_3*t));
v_4 = 1/8*(cos(2*pi*f_4*t));
signal = v_1 + v_2 + v_3 + v_4 + 0.5*runif(nv,min=-0.5,max=0.5);
v = vmd(signal,alpha=2000,tau=0,DC=FALSE,init=0,tol=1e-3,K=3,orderModes=TRUE)

#List of Results
l = v$getResult()
names(l)

#To Data Frame
df = as.data.frame(v)
head(df)

#Plot Results
plot(v)
plot(v,facet='bymode',scales='free')
plot(v,facet='byclass',scales='free')

#Input Spectrum
v$plot.input.spectrum()

#Spectral Decomposition
v$plot.spectral.decomposition()

}
\author{
Nicholas Hamilton, UNSW Sydney
}
\references{
Variational Mode Decomposition, Dragomiretskiy & Zorro, 2013, http://dx.doi.org/10.1109/TSP.2013.2288675

Original Matlab Source: https://goo.gl/fJH1d5.
}
\keyword{datasets}

