% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{getTurnType}
\alias{getTurnType}
\title{getTurnType: return type of turn}
\usage{
getTurnType(df, i, individual = FALSE, nodecolumn = "speaker",
  noPauseTypes = F)
}
\arguments{
\item{df}{a data frame consisting, minimally, of a column for
vocalisation/pause start times, a column for end times, and a
column identifying the speaker, speaker role or 'Floor' (for
silences).}

\item{i}{the identifier (index number) whose type will be returned}

\item{individual}{if TRUE, return the identifier, a Pause or Grp}

\item{nodecolumn}{the name of the column containing the node
(speaker) name (e.g. 'speaker', 'role').}

\item{noPauseTypes}{if TRUE, ignore distinctions between pauses
(SwitchingPause, GrpSwitchingPause, etc)}
}
\value{
a string containing the turn type or identifier.
}
\description{
Identify turn types
}
\details{
Return one of {Vocalisation, GrpVocalisation, ...} or identifier.
}
\examples{
data(vocdia)
atddia[1:10,]
getTurnType(atddia, 3, nodecolumn='role') ## a vocalisation
getTurnType(atddia, 4, nodecolumn='role') ## a pause
}
