% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocalgraphs.R
\name{namePauses}
\alias{namePauses}
\title{namePauses: name pause types.}
\usage{
namePauses(df, nodecolumn = "role")
}
\arguments{
\item{df}{a data frame consisting, minimally, of a column for
vocalisation/pause start times, a column for end times, and a
column identifying the speaker, speaker role or 'Floor' (for
silences).}

\item{nodecolumn}{the name of the column containing the node
(speaker) name (e.g. 'speaker', 'role').}
}
\value{
a data.frame with pauses in nodecolumn replaced by different pause types.
}
\description{
Replace identified pause pause types in data frame.
}
\details{
replace all 'Floor' speakers in df by 'Pause', 'SwitchingPause'
etc, and return a new data fame containing pause types in place of
'Floor' (see markov.R, identifyPauses() for a better
implementation)
}
\examples{
data(vocdia)
x <- subset(atddia, id=='Abbott_Maddock_01')
x[1:15,1:6]
namePauses(x)[1:15,1:6]
}
\seealso{
\code{\link{identifyPauses}} for a better implementation
}
