% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_right.R
\name{get_right}
\alias{get_right}
\title{Get right channel}
\usage{
get_right(x)
}
\arguments{
\item{x}{Wave object from `tuneR::readWave`.}
}
\value{
A numeric vector indicating the right channel from a WAV file.
}
\description{
Get right channel from WAV file.
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

rw <- tuneR::readWave(path2wav[1])
r <- voice::get_right(rw)
head(r)
length(r)
}
