% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{copula}
\alias{copula}
\title{Construct a copula using uniform sampling from the unit simplex}
\usage{
copula(r1, r2 = NULL, sigma = NULL, m = NULL, n = NULL,
  seed = NULL)
}
\arguments{
\item{r1}{The \eqn{d}-dimensional normal vector of the first family of parallel hyperplanes.}

\item{r2}{Optional. The \eqn{d}-dimensional normal vector of the second family of parallel hyperplanes.}

\item{sigma}{Optional. The \eqn{d\times d} symmetric positive semidefine matrix that describes the family of concentric ellipsoids centered at the origin.}

\item{m}{The number of the slices for the copula. The default value is 100.}

\item{n}{The number of points to sample. The default value is \eqn{5\cdot 10^5}.}

\item{seed}{Optional. A fixed seed for the number generator.}
}
\value{
A \eqn{m\times m} numerical matrix that corresponds to a copula.
}
\description{
Given two families of parallel hyperplanes or a family of parallel hyperplanes and a family of concentric ellispoids centered at the origin intersecting the canonical simplex, this function uniformly samples from the canonical simplex and construct an approximation of the bivariate probability distribution, called copula (see \url{https://en.wikipedia.org/wiki/Copula_(probability_theory)}).
At least two families of hyperplanes or one family of hyperplanes and one family of ellipsoids have to be given as input.
}
\examples{
# compute a copula for two random families of parallel hyperplanes
h1 = runif(n = 10, min = 1, max = 1000)
h1 = h1 / 1000
h2=runif(n = 10, min = 1, max = 1000)
h2 = h2 / 1000
cop = copula(r1 = h1, r2 = h2, m = 10, n = 100000)

# compute a copula for a family of parallel hyperplanes and a family of conentric ellipsoids
h = runif(n = 10, min = 1, max = 1000)
h = h / 1000
E = replicate(10, rnorm(20))
E = cov(E)
cop = copula(r1 = h, sigma = E, m = 10, n = 100000)

}
\references{
\cite{L. Cales, A. Chalkis, I.Z. Emiris, V. Fisikopoulos,
\dQuote{Practical volume computation of structured convex bodies, and an application to modeling portfolio dependencies and financial crises,} \emph{Proc. of Symposium on Computational Geometry, Budapest, Hungary,} 2018.}
}
