% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_cube.R
\name{gen_cube}
\alias{gen_cube}
\title{Generator function for hypercubes}
\usage{
gen_cube(dimension, representation = "H")
}
\arguments{
\item{dimension}{The dimension of the hypercube}

\item{representation}{A string to declare the representation. It has to be \code{'H'} for H-representation or \code{'V'} for V-representation. Default valus is 'H'.}
}
\value{
A polytope class representing the unit \eqn{d}-dimensional hypercube in H- or V-representation.
}
\description{
This function generates the \eqn{d}-dimensional unit hypercube \eqn{[-1,1]^d} in H- or V-representation.
}
\examples{
# generate a 10-dimensional hypercube in H-representation
P = gen_cube(10, 'H')

# generate a 15-dimension hypercube in V-representation
P = gen_cube(5, 'V')
}
