% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.reddit.R
\name{Create.actor.reddit}
\alias{Create.actor.reddit}
\title{Create reddit actor network}
\usage{
\method{Create}{actor.reddit}(datasource, type, weightEdges = FALSE,
  textData = FALSE, cleanText = TRUE, writeToFile = FALSE, ...)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"reddit"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{weightEdges}{Logical. Combine and weight directed network edges. Default is \code{FALSE}.}

\item{textData}{Logical. Include comment text as an edge attributes of returned igraph network. Is set to 
\code{FALSE} if the \code{weightEdges} parameter is \code{TRUE} as text merging is not supported. Default is 
\code{FALSE}.}

\item{cleanText}{Logical. Simple removal of non-alphanumeric, non-punctuation, and non-space characters from 
the comment text data applied as graph edge attribute. Not suitable in some cases requiring capture of utf or emoji 
characters. Implemented to support basic text analysis and to prevent reddit specific XML control character errors 
in the graphml files created by this function. Alternatively custom cleaning of text data can be performed on the 
\code{datasource} dataframe before being passed to this function. Default is \code{TRUE}.}

\item{writeToFile}{Logical. Save network data to a file in the current working directory. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Named list containing generated network as igraph object \code{$graph}.
}
\description{
Creates a reddit actor network from thread comments on subreddits. Users who have commented on a thread 
are actor nodes and comment replies to each other are represented as directed edges. Optionally a graph with edge 
weights (\code{weight}) or edge text attributes (\code{vosonTxt_comment}) can be created.
}
\examples{
\dontrun{
# create a reddit actor network graph with comment text as edge attributes
actorNetwork <- redditData \%>\% 
  Create("actor", includeTextData = TRUE, writeToFile = TRUE)

# igraph object
# actorNetwork$graph
}

}
