% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.twitter.R
\name{Create.actor.twitter}
\alias{Create.actor.twitter}
\title{Create twitter actor network}
\usage{
\method{Create}{actor.twitter}(
  datasource,
  type,
  rmEdgeTypes = NULL,
  inclMentions = TRUE,
  inclRtMentions = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"twitter"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{rmEdgeTypes}{Character vector. List of edge types to remove from network. Options are \code{"tweet"},
\code{"retweet"}, \code{"reply"} and \code{"quote"}. Default is \code{NULL}.}

\item{inclMentions}{Logical. Create edges for users mentioned or tagged in tweets. Default is \code{TRUE}.}

\item{inclRtMentions}{Logical. Create edges for users mentioned or tagged in retweets. For tweet types other than
retweets the collected tweet author has created the mention, for retweets the original tweet author has created the
mention not the retweeter. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a twitter actor network from tweets returned from the twitter search query. Twitter users who
have tweeted, retweeted or been mentioned in a tweet are actor nodes. The created network is directed with edges of
different types representing retweets, quote tweets, mentions and replies to other users. Users who have tweeted
without ties to other users will appear in the network graph as nodes with self-loops.
}
\note{
When creating twitter actor networks, a network with additional user information can be generated using the
\code{\link{AddUserData}} function. Additional calls can be made to the twitter API to get information about users
that were identified as nodes during network creation but did not tweet (meaning no user profile information was
initially collected for them).
}
\examples{
\dontrun{
# create a twitter actor network excluding retweet, quote tweets and mention edges
actor_net <- twitter_data |>
  Create("actor", rmEdgeTypes = c("retweet", "quote"))

# network nodes and edges
names(actor_net)
# "nodes", "edges"
names(actor_net$nodes)
# "user_id", "screen_name"
names(actor_net$edges)
# "from", "to", "status_id", "created_at", "edge_type"
}

}
